/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.plugins.baseplugin.actions;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.actions.Action;
import org.apache.unomi.api.actions.ActionExecutor;
import org.apache.unomi.api.services.EventService;
import org.apache.unomi.persistence.spi.PropertyHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetPropertyAction
implements ActionExecutor {
    private static final Logger logger = LoggerFactory.getLogger((String)SetPropertyAction.class.getName());
    private EventService eventService;
    private boolean useEventToUpdateProfile = false;

    public void setUseEventToUpdateProfile(boolean useEventToUpdateProfile) {
        this.useEventToUpdateProfile = useEventToUpdateProfile;
    }

    public int execute(Action action, Event event) {
        boolean storeInSession = Boolean.TRUE.equals(action.getParameterValues().get("storeInSession"));
        if (storeInSession && event.getSession() == null) {
            return 0;
        }
        String propertyName = (String)action.getParameterValues().get("setPropertyName");
        Object propertyValue = action.getParameterValues().get("setPropertyValue");
        if (propertyValue == null) {
            propertyValue = action.getParameterValues().get("setPropertyValueMultiple");
        }
        Object propertyValueInteger = action.getParameterValues().get("setPropertyValueInteger");
        Object setPropertyValueMultiple = action.getParameterValues().get("setPropertyValueMultiple");
        Object setPropertyValueBoolean = action.getParameterValues().get("setPropertyValueBoolean");
        if (propertyValue == null) {
            if (propertyValueInteger != null) {
                propertyValue = PropertyHelper.getInteger(propertyValueInteger);
            }
            if (setPropertyValueMultiple != null) {
                propertyValue = setPropertyValueMultiple;
            }
            if (setPropertyValueBoolean != null) {
                propertyValue = PropertyHelper.getBooleanValue(setPropertyValueBoolean);
            }
        }
        if (propertyValue != null && propertyValue.equals("now")) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            Date date = new Date();
            Date firstVisit = new Date();
            try {
                Object propertyFirstVisit = event.getProfile().getProperties().get("firstVisit");
                if (propertyFirstVisit != null) {
                    firstVisit = propertyFirstVisit instanceof String ? format.parse((String)propertyFirstVisit) : (propertyFirstVisit instanceof Date ? (Date)propertyFirstVisit : format.parse(propertyFirstVisit.toString()));
                }
                if (event.getTimeStamp().after(firstVisit)) {
                    date = event.getTimeStamp();
                }
            }
            catch (ParseException e) {
                logger.error("Error to parse date", (Throwable)e);
            }
            propertyValue = format.format(date);
        }
        if (storeInSession) {
            if (PropertyHelper.setProperty((Object)event.getSession(), (String)propertyName, propertyValue, (String)((String)action.getParameterValues().get("setPropertyStrategy")))) {
                return 2;
            }
        } else if (this.useEventToUpdateProfile) {
            HashMap propertyToUpdate = new HashMap();
            propertyToUpdate.put(propertyName, propertyValue);
            Event updateProperties = new Event("updateProperties", event.getSession(), event.getProfile(), event.getScope(), null, (Item)event.getProfile(), new Date());
            updateProperties.setPersistent(false);
            updateProperties.setProperty("update", propertyToUpdate);
            int changes = this.eventService.send(updateProperties);
            if ((changes & 4) == 4) {
                return 4;
            }
        } else if (PropertyHelper.setProperty((Object)event.getProfile(), (String)propertyName, propertyValue, (String)((String)action.getParameterValues().get("setPropertyStrategy")))) {
            return 4;
        }
        return 0;
    }

    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }
}

