/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.cm.impl.UpdateThread;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.coordinator.Coordinator;
import org.osgi.service.coordinator.Participant;

public class CoordinatorUtil {
    public static boolean addToCoordination(Object srv, UpdateThread thread, Runnable task) {
        Coordinator coordinator = (Coordinator)srv;
        Coordination c = coordinator.peek();
        if (c != null && !c.isTerminated()) {
            Notifier n = null;
            for (Participant p : c.getParticipants()) {
                if (!(p instanceof Notifier)) continue;
                n = (Notifier)p;
                break;
            }
            if (n == null) {
                n = new Notifier(thread);
                c.addParticipant((Participant)n);
            }
            n.add(task);
            return true;
        }
        return false;
    }

    public static final class Notifier
    implements Participant {
        private final List<Runnable> runnables = new ArrayList<Runnable>();
        private final UpdateThread thread;

        public Notifier(UpdateThread t) {
            this.thread = t;
        }

        private void execute() {
            for (Runnable r : this.runnables) {
                this.thread.schedule(r);
            }
            this.runnables.clear();
        }

        public void ended(Coordination coordination) throws Exception {
            this.execute();
        }

        public void failed(Coordination coordination) throws Exception {
            this.execute();
        }

        public void add(Runnable t) {
            this.runnables.add(t);
        }
    }
}

