/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.ssl.util.Hex;

class ASN1Structure {
    List derIntegers = new LinkedList();
    Set oids = new TreeSet();
    String oid1;
    String oid2;
    String oid3;
    byte[] salt;
    byte[] iv;
    int iterationCount;
    int keySize;
    byte[] bigPayload;
    byte[] smallPayload;

    ASN1Structure() {
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(256);
        buf.append("------ ASN.1 PKCS Structure ------");
        buf.append("\noid1:    ");
        buf.append(this.oid1);
        if (this.oid2 != null) {
            buf.append("\noid2:    ");
            buf.append(this.oid2);
        }
        buf.append("\nsalt:   ");
        if (this.salt != null) {
            buf.append(Hex.encode(this.salt));
        } else {
            buf.append("[null]");
        }
        buf.append("\nic:      ");
        buf.append(Integer.toString(this.iterationCount));
        if (this.keySize != 0) {
            buf.append("\nkeySize: ");
            buf.append(Integer.toString(this.keySize * 8));
        }
        if (this.oid2 != null) {
            buf.append("\noid3:    ");
            buf.append(this.oid3);
        }
        if (this.oid2 != null) {
            buf.append("\niv:      ");
            if (this.iv != null) {
                buf.append(Hex.encode(this.iv));
            } else {
                buf.append("[null]");
            }
        }
        if (this.bigPayload != null) {
            buf.append("\nbigPayload-length:   ");
            buf.append(this.bigPayload.length);
        }
        if (this.smallPayload != null) {
            buf.append("\nsmallPayload-length: ");
            buf.append(this.smallPayload.length);
        }
        if (!this.oids.isEmpty()) {
            Iterator it = this.oids.iterator();
            buf.append("\nAll oids:");
            while (it.hasNext()) {
                buf.append("\n");
                buf.append((String)it.next());
            }
        }
        return buf.toString();
    }
}

