/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.jaxrs2;

import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
@Produces(value={"application/json", "application/xml", "application/yaml"})
public class SwaggerSerializers
implements MessageBodyWriter<OpenAPI> {
    static boolean prettyPrint = false;

    public static void setPrettyPrint(boolean shouldPrettyPrint) {
        prettyPrint = shouldPrettyPrint;
    }

    public boolean isWriteable(Class type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return OpenAPI.class.isAssignableFrom(type);
    }

    public long getSize(OpenAPI data, Class type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(OpenAPI data, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> headers, OutputStream out) throws IOException {
        if (mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
            if (prettyPrint) {
                out.write(Json.pretty().writeValueAsBytes((Object)data));
            } else {
                out.write(Json.mapper().writeValueAsBytes((Object)data));
            }
        } else if (mediaType.toString().startsWith("application/yaml")) {
            headers.remove((Object)"Content-Type");
            headers.add((Object)"Content-Type", (Object)"application/yaml");
            if (prettyPrint) {
                out.write(Yaml.pretty().writeValueAsBytes((Object)data));
            } else {
                out.write(Yaml.mapper().writeValueAsBytes((Object)data));
            }
        } else if (mediaType.isCompatible(MediaType.APPLICATION_XML_TYPE)) {
            headers.remove((Object)"Content-Type");
            headers.add((Object)"Content-Type", (Object)"application/json");
            if (prettyPrint) {
                out.write(Json.pretty().writeValueAsBytes((Object)data));
            } else {
                out.write(Json.mapper().writeValueAsBytes((Object)data));
            }
        }
    }
}

