/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.api;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.Session;
import org.apache.unomi.api.TimestampedItem;
import org.apache.unomi.api.actions.ActionPostExecutor;

public class Event
extends Item
implements TimestampedItem {
    public static final String ITEM_TYPE = "event";
    public static final String HTTP_REQUEST_ATTRIBUTE = "http_request";
    public static final String HTTP_RESPONSE_ATTRIBUTE = "http_response";
    private static final long serialVersionUID = -1096874942838593575L;
    private String eventType;
    private String sessionId = null;
    private String profileId = null;
    private Date timeStamp;
    private Map<String, Object> properties;
    private transient Profile profile;
    private transient Session session;
    private transient List<ActionPostExecutor> actionPostExecutors;
    private String scope;
    private Item source;
    private Item target;
    private boolean persistent = true;
    private transient Map<String, Object> attributes = new LinkedHashMap<String, Object>();

    public Event() {
    }

    public Event(String itemId, String eventType, Session session, Profile profile, String scope, Item source, Item target, Date timestamp) {
        super(itemId);
        this.initEvent(eventType, session, profile, scope, source, target, timestamp);
    }

    public Event(String eventType, Session session, Profile profile, String scope, Item source, Item target, Date timestamp) {
        this(eventType, session, profile, scope, source, target, null, timestamp, true);
    }

    public Event(String eventType, Session session, Profile profile, String scope, Item source, Item target, Map<String, Object> properties, Date timestamp, boolean persistent) {
        this(UUID.randomUUID().toString(), eventType, session, profile, scope, source, target, properties, timestamp, persistent);
    }

    public Event(String itemId, String eventType, Session session, Profile profile, String scope, Item source, Item target, Map<String, Object> properties, Date timestamp, boolean persistent) {
        this(itemId, eventType, session, profile, scope, source, target, timestamp);
        this.persistent = persistent;
        if (properties != null) {
            this.properties = properties;
        }
    }

    private void initEvent(String eventType, Session session, Profile profile, String scope, Item source, Item target, Date timestamp) {
        this.eventType = eventType;
        this.profile = profile;
        this.session = session;
        this.profileId = profile.getItemId();
        this.scope = scope;
        this.source = source;
        this.target = target;
        if (session != null) {
            this.sessionId = session.getItemId();
        }
        this.timeStamp = timestamp;
        this.properties = new HashMap<String, Object>();
        this.actionPostExecutors = new ArrayList<ActionPostExecutor>();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public void setProfileId(String profileId) {
        this.profileId = profileId;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    @Override
    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    @XmlTransient
    public Profile getProfile() {
        return this.profile;
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
    }

    @XmlTransient
    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    @XmlTransient
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public void setScope(String scope) {
        this.scope = scope;
    }

    public Item getSource() {
        return this.source;
    }

    public void setSource(Item source) {
        this.source = source;
    }

    public Item getTarget() {
        return this.target;
    }

    public void setTarget(Item target) {
        this.target = target;
    }

    @XmlTransient
    public List<ActionPostExecutor> getActionPostExecutors() {
        return this.actionPostExecutors;
    }

    public void setActionPostExecutors(List<ActionPostExecutor> actionPostExecutors) {
        this.actionPostExecutors = actionPostExecutors;
    }
}

