/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.env;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import joptsimple.OptionParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cluster.coordination.ElasticsearchNodeCommand;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeMetaData;

public class OverrideNodeVersionCommand
extends ElasticsearchNodeCommand {
    private static final Logger logger = LogManager.getLogger(OverrideNodeVersionCommand.class);
    private static final String TOO_NEW_MESSAGE = "------------------------------------------------------------------------\n\nThis data path was last written by Elasticsearch version [V_NEW] and may no\nlonger be compatible with Elasticsearch version [V_CUR]. This tool will bypass\nthis compatibility check, allowing a version [V_CUR] node to start on this data\npath, but a version [V_CUR] node may not be able to read this data or may read\nit incorrectly leading to data loss.\n\nYou should not use this tool. Instead, continue to use a version [V_NEW] node\non this data path. If necessary, you can use reindex-from-remote to copy the\ndata from here into an older cluster.\n\nDo you want to proceed?\n";
    private static final String TOO_OLD_MESSAGE = "------------------------------------------------------------------------\n\nThis data path was last written by Elasticsearch version [V_OLD] which may be\ntoo old to be readable by Elasticsearch version [V_CUR].  This tool will bypass\nthis compatibility check, allowing a version [V_CUR] node to start on this data\npath, but this version [V_CUR] node may not be able to read this data or may\nread it incorrectly leading to data loss.\n\nYou should not use this tool. Instead, upgrade this data path from [V_OLD] to\n[V_CUR] using one or more intermediate versions of Elasticsearch.\n\nDo you want to proceed?\n";
    static final String NO_METADATA_MESSAGE = "no node metadata found, so there is no version to override";
    static final String SUCCESS_MESSAGE = "Successfully overwrote this node's metadata to bypass its version compatibility checks.";

    public OverrideNodeVersionCommand() {
        super("Overwrite the version stored in this node's data path with [" + Version.CURRENT + "] to bypass the version compatibility checks");
    }

    @Override
    protected void processNodePaths(Terminal terminal, Path[] dataPaths, Environment env) throws IOException {
        Path[] nodePaths = (Path[])Arrays.stream(this.toNodePaths(dataPaths)).map(p -> p.path).toArray(Path[]::new);
        NodeMetaData nodeMetaData = (NodeMetaData)new NodeMetaData.NodeMetaDataStateFormat(true).loadLatestState(logger, this.namedXContentRegistry, nodePaths);
        if (nodeMetaData == null) {
            throw new ElasticsearchException(NO_METADATA_MESSAGE, new Object[0]);
        }
        try {
            nodeMetaData.upgradeToCurrentVersion();
            throw new ElasticsearchException("found [" + nodeMetaData + "] which is compatible with current version [" + Version.CURRENT + "], so there is no need to override the version checks", new Object[0]);
        }
        catch (IllegalStateException illegalStateException) {
            this.confirm(terminal, (nodeMetaData.nodeVersion().before(Version.CURRENT) ? TOO_OLD_MESSAGE : TOO_NEW_MESSAGE).replace("V_OLD", nodeMetaData.nodeVersion().toString()).replace("V_NEW", nodeMetaData.nodeVersion().toString()).replace("V_CUR", Version.CURRENT.toString()));
            NodeMetaData.FORMAT.writeAndCleanup(new NodeMetaData(nodeMetaData.nodeId(), Version.CURRENT), nodePaths);
            terminal.println(SUCCESS_MESSAGE);
            return;
        }
    }

    OptionParser getParser() {
        return this.parser;
    }
}

