/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.config.internal.osgi;

import java.io.File;
import java.util.Hashtable;
import org.apache.karaf.cellar.config.ConfigurationEventHandler;
import org.apache.karaf.cellar.config.ConfigurationSynchronizer;
import org.apache.karaf.cellar.config.LocalConfigurationListener;
import org.apache.karaf.cellar.config.management.CellarConfigMBean;
import org.apache.karaf.cellar.config.management.internal.CellarConfigMBeanImpl;
import org.apache.karaf.cellar.core.ClusterManager;
import org.apache.karaf.cellar.core.GroupManager;
import org.apache.karaf.cellar.core.Synchronizer;
import org.apache.karaf.cellar.core.event.EventHandler;
import org.apache.karaf.cellar.core.event.EventProducer;
import org.apache.karaf.util.tracker.BaseActivator;
import org.apache.karaf.util.tracker.annotation.Managed;
import org.apache.karaf.util.tracker.annotation.ProvideService;
import org.apache.karaf.util.tracker.annotation.RequireService;
import org.apache.karaf.util.tracker.annotation.Services;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Services(requires={@RequireService(value=ClusterManager.class), @RequireService(value=GroupManager.class), @RequireService(value=ConfigurationAdmin.class), @RequireService(value=EventProducer.class)}, provides={@ProvideService(value=ConfigurationListener.class), @ProvideService(value=Synchronizer.class), @ProvideService(value=EventHandler.class), @ProvideService(value=CellarConfigMBean.class)})
@Managed(value="org.apache.karaf.shell.config")
public class Activator
extends BaseActivator
implements ManagedService {
    private static final Logger LOGGER = LoggerFactory.getLogger(Activator.class);
    private LocalConfigurationListener localConfigurationListener;
    private ConfigurationSynchronizer configurationSynchronizer;
    private ConfigurationEventHandler configurationEventHandler;
    private ServiceRegistration cellarConfigMBeanRegistration;

    @Override
    public void doStart() throws Exception {
        ClusterManager clusterManager = this.getTrackedService(ClusterManager.class);
        if (clusterManager == null) {
            return;
        }
        GroupManager groupManager = this.getTrackedService(GroupManager.class);
        if (groupManager == null) {
            return;
        }
        ConfigurationAdmin configurationAdmin = this.getTrackedService(ConfigurationAdmin.class);
        if (configurationAdmin == null) {
            return;
        }
        EventProducer eventProducer = this.getTrackedService(EventProducer.class);
        if (eventProducer == null) {
            return;
        }
        File storage = new File(this.getString("storage", System.getProperty("karaf.etc")));
        LOGGER.debug("CELLAR CONFIG: init event handler");
        this.configurationEventHandler = new ConfigurationEventHandler();
        this.configurationEventHandler.setConfigurationAdmin(configurationAdmin);
        this.configurationEventHandler.setGroupManager(groupManager);
        this.configurationEventHandler.setClusterManager(clusterManager);
        this.configurationEventHandler.setStorage(storage);
        this.configurationEventHandler.init();
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("managed", "true");
        this.register(EventHandler.class, this.configurationEventHandler, props);
        LOGGER.debug("CELLAR CONFIG: init local listener");
        this.localConfigurationListener = new LocalConfigurationListener();
        this.localConfigurationListener.setClusterManager(clusterManager);
        this.localConfigurationListener.setGroupManager(groupManager);
        this.localConfigurationListener.setConfigurationAdmin(configurationAdmin);
        this.localConfigurationListener.setEventProducer(eventProducer);
        this.localConfigurationListener.setStorage(storage);
        this.localConfigurationListener.init();
        this.register(ConfigurationListener.class, this.localConfigurationListener);
        LOGGER.debug("CELLAR CONFIG: init synchronizer");
        this.configurationSynchronizer = new ConfigurationSynchronizer();
        this.configurationSynchronizer.setConfigurationAdmin(configurationAdmin);
        this.configurationSynchronizer.setGroupManager(groupManager);
        this.configurationSynchronizer.setClusterManager(clusterManager);
        this.configurationSynchronizer.setEventProducer(eventProducer);
        this.configurationSynchronizer.setStorage(storage);
        this.configurationSynchronizer.init(this.bundleContext);
        props = new Hashtable();
        props.put("resource", "config");
        this.register(Synchronizer.class, this.configurationSynchronizer, props);
        LOGGER.debug("CELLAR CONFIG: register MBean");
        CellarConfigMBeanImpl cellarConfigMBean = new CellarConfigMBeanImpl();
        cellarConfigMBean.setClusterManager(clusterManager);
        cellarConfigMBean.setGroupManager(groupManager);
        cellarConfigMBean.setConfigurationAdmin(configurationAdmin);
        cellarConfigMBean.setEventProducer(eventProducer);
        props = new Hashtable();
        props.put("jmx.objectname", "org.apache.karaf.cellar:type=config,name=" + System.getProperty("karaf.name"));
        this.cellarConfigMBeanRegistration = this.bundleContext.registerService(this.getInterfaceNames(cellarConfigMBean), (Object)cellarConfigMBean, props);
    }

    @Override
    public void doStop() {
        super.doStop();
        if (this.cellarConfigMBeanRegistration != null) {
            this.cellarConfigMBeanRegistration.unregister();
            this.cellarConfigMBeanRegistration = null;
        }
        if (this.configurationSynchronizer != null) {
            this.configurationSynchronizer.destroy();
            this.configurationSynchronizer = null;
        }
        if (this.localConfigurationListener != null) {
            this.localConfigurationListener.destroy();
            this.localConfigurationListener = null;
        }
        if (this.configurationEventHandler != null) {
            this.configurationEventHandler.destroy();
            this.configurationEventHandler = null;
        }
    }
}

