/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.config.shell;

import java.util.Set;
import org.apache.karaf.cellar.config.shell.completers.ClusterConfigCompleter;
import org.apache.karaf.cellar.core.CellarSupport;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.event.EventType;
import org.apache.karaf.cellar.core.shell.CellarCommandSupport;
import org.apache.karaf.cellar.core.shell.completer.AllGroupsCompleter;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="cluster", name="config-block", description="Change the blocking policy for a bundle")
@Service
public class BlockCommand
extends CellarCommandSupport {
    @Argument(index=0, name="group", description="The cluster group name", required=true, multiValued=false)
    @Completion(value=AllGroupsCompleter.class)
    String groupName;
    @Argument(index=1, name="pidPattern", description="The configuration PID pattern", required=false, multiValued=false)
    @Completion(value=ClusterConfigCompleter.class)
    String pid;
    @Option(name="-in", description="Update the inbound direction", required=false, multiValued=false)
    boolean in = false;
    @Option(name="-out", description="Update the outbound direction", required=false, multiValued=false)
    boolean out = false;
    @Option(name="-whitelist", description="Allow the feature by updating the whitelist (false by default)", required=false, multiValued=false)
    boolean whitelist = false;
    @Option(name="-blacklist", description="Block the feature by updating the blacklist (true by default)", required=false, multiValued=false)
    boolean blacklist = false;

    public Object doExecute() throws Exception {
        Group group = this.groupManager.findGroupByName(this.groupName);
        if (group == null) {
            System.err.println("Cluster group " + this.groupName + " doesn't exist");
            return null;
        }
        CellarSupport support = new CellarSupport();
        support.setClusterManager(this.clusterManager);
        support.setGroupManager(this.groupManager);
        support.setConfigurationAdmin(this.configurationAdmin);
        if (!this.in && !this.out) {
            this.in = true;
            this.out = true;
        }
        if (!this.whitelist && !this.blacklist) {
            this.whitelist = true;
            this.blacklist = true;
        }
        if (this.pid == null || this.pid.isEmpty()) {
            Set list;
            if (this.in) {
                System.out.println("INBOUND:");
                if (this.whitelist) {
                    System.out.print("\twhitelist: ");
                    list = support.getListEntries("whitelist", this.groupName, "config", EventType.INBOUND);
                    System.out.println(list.toString());
                }
                if (this.blacklist) {
                    System.out.print("\tblacklist: ");
                    list = support.getListEntries("blacklist", this.groupName, "config", EventType.INBOUND);
                    System.out.println(list.toString());
                }
            }
            if (this.out) {
                System.out.println("OUTBOUND:");
                if (this.whitelist) {
                    System.out.print("\twhitelist: ");
                    list = support.getListEntries("whitelist", this.groupName, "config", EventType.OUTBOUND);
                    System.out.println(list.toString());
                }
                if (this.blacklist) {
                    System.out.print("\tblacklist: ");
                    list = support.getListEntries("blacklist", this.groupName, "config", EventType.OUTBOUND);
                    System.out.println(list.toString());
                }
            }
        } else {
            System.out.println("Updating blocking policy for " + this.pid);
            if (this.in) {
                if (this.whitelist) {
                    System.out.println("\tinbound whitelist ...");
                    support.switchListEntry("whitelist", this.groupName, "config", EventType.INBOUND, this.pid);
                }
                if (this.blacklist) {
                    System.out.println("\tinbound blacklist ...");
                    support.switchListEntry("blacklist", this.groupName, "config", EventType.INBOUND, this.pid);
                }
            }
            if (this.out) {
                if (this.whitelist) {
                    System.out.println("\toutbound whitelist ...");
                    support.switchListEntry("whitelist", this.groupName, "config", EventType.OUTBOUND, this.pid);
                }
                if (this.blacklist) {
                    System.out.println("\toutbound blacklist ...");
                    support.switchListEntry("blacklist", this.groupName, "config", EventType.OUTBOUND, this.pid);
                }
            }
        }
        return null;
    }
}

