/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.bundle;

import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.cellar.bundle.BundleState;
import org.apache.karaf.cellar.bundle.BundleSupport;
import org.apache.karaf.cellar.bundle.ClusterBundleEvent;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.control.SwitchStatus;
import org.apache.karaf.cellar.core.event.Event;
import org.apache.karaf.cellar.core.event.EventProducer;
import org.apache.karaf.cellar.core.event.EventType;
import org.apache.karaf.features.Feature;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.service.cm.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalBundleListener
extends BundleSupport
implements SynchronousBundleListener {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(LocalBundleListener.class);
    private EventProducer eventProducer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleChanged(BundleEvent event) {
        if (event.getBundle().getBundleId() == 0L && (event.getType() == 256 || event.getType() == 4)) {
            LOGGER.debug("CELLAR BUNDLE: Karaf shutdown detected, removing Cellar LocalBundleListener");
            this.bundleContext.removeBundleListener((BundleListener)this);
            return;
        }
        if (!this.isEnabled()) {
            LOGGER.trace("CELLAR BUNDLE: local listener is disabled");
            return;
        }
        if (event.getBundle().getBundleId() == 0L) {
            return;
        }
        if (this.eventProducer.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
            LOGGER.debug("CELLAR BUNDLE: cluster event producer is OFF");
            return;
        }
        if (event != null && event.getBundle() != null) {
            Set groups = null;
            try {
                groups = this.groupManager.listLocalGroups();
            }
            catch (Exception ex) {
                LOGGER.warn("Failed to list local groups. Is Cellar uninstalling ?");
            }
            if (groups != null && !groups.isEmpty()) {
                for (Group group : groups) {
                    String name = (String)event.getBundle().getHeaders().get("Bundle-Name");
                    name = name == null ? event.getBundle().getSymbolicName() : name;
                    name = name == null ? event.getBundle().getLocation() : name;
                    String symbolicName = event.getBundle().getSymbolicName();
                    String version = (String)event.getBundle().getHeaders().get("Bundle-Version");
                    String bundleLocation = event.getBundle().getLocation();
                    int status = event.getBundle().getState();
                    int startLevel = ((BundleStartLevel)event.getBundle().adapt(BundleStartLevel.class)).getStartLevel();
                    if (this.isAllowed(group, "bundle", bundleLocation, EventType.OUTBOUND).booleanValue()) {
                        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                        try {
                            Map clusterBundles = this.clusterManager.getMap("org.apache.karaf.cellar.bundle.map." + group.getName());
                            if (event.getType() == 16) {
                                clusterBundles.remove(symbolicName + "/" + version);
                            } else {
                                BundleState state = (BundleState)clusterBundles.get(symbolicName + "/" + version);
                                if (state == null) {
                                    state = new BundleState();
                                }
                                state.setId(event.getBundle().getBundleId());
                                state.setName(name);
                                state.setVersion(version);
                                state.setSymbolicName(symbolicName);
                                state.setStatus(status);
                                state.setStartLevel(startLevel);
                                state.setLocation(bundleLocation);
                                clusterBundles.put(symbolicName + "/" + version, state);
                            }
                            List<Feature> matchingFeatures = this.retrieveFeature(bundleLocation);
                            for (Feature feature : matchingFeatures) {
                                if (this.isAllowed(group, "feature", feature.getName(), EventType.OUTBOUND).booleanValue()) continue;
                                LOGGER.trace("CELLAR BUNDLE: bundle {} is contained in feature {} marked BLOCKED OUTBOUND for cluster group {}", new Object[]{bundleLocation, feature.getName(), group.getName()});
                                return;
                            }
                            ClusterBundleEvent clusterBundleEvent = new ClusterBundleEvent(symbolicName, version, bundleLocation, startLevel, status);
                            clusterBundleEvent.setSourceGroup(group);
                            clusterBundleEvent.setSourceNode(this.clusterManager.getNode());
                            clusterBundleEvent.setLocal(this.clusterManager.getNode());
                            this.eventProducer.produce((Event)clusterBundleEvent);
                            continue;
                        }
                        catch (Exception e) {
                            LOGGER.error("CELLAR BUNDLE: failed to create bundle event", (Throwable)e);
                            continue;
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(originalClassLoader);
                            continue;
                        }
                    }
                    LOGGER.trace("CELLAR BUNDLE: bundle {} is marked BLOCKED OUTBOUND for cluster group {}", (Object)bundleLocation, (Object)group.getName());
                }
            }
        }
    }

    private boolean isEnabled() {
        try {
            Configuration configuration = this.configurationAdmin.getConfiguration("org.apache.karaf.cellar.node", null);
            Dictionary properties = configuration.getProperties();
            if (properties != null) {
                String value = properties.get("bundle.listener").toString();
                return Boolean.parseBoolean(value);
            }
        }
        catch (Exception e) {
            LOGGER.warn("CELLAR BUNDLE: can't check listener configuration", (Throwable)e);
        }
        return false;
    }

    public void init() {
        this.getBundleContext().addBundleListener((BundleListener)this);
    }

    public void destroy() {
        this.bundleContext.removeBundleListener((BundleListener)this);
    }

    public EventProducer getEventProducer() {
        return this.eventProducer;
    }

    public void setEventProducer(EventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }
}

