/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.services.impl.profiles;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.api.BatchUpdate;
import org.apache.unomi.api.Consent;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.Persona;
import org.apache.unomi.api.PersonaSession;
import org.apache.unomi.api.PersonaWithSessions;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.ProfileAlias;
import org.apache.unomi.api.PropertyMergeStrategyExecutor;
import org.apache.unomi.api.PropertyMergeStrategyType;
import org.apache.unomi.api.PropertyType;
import org.apache.unomi.api.Session;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.conditions.ConditionType;
import org.apache.unomi.api.query.Query;
import org.apache.unomi.api.segments.Segment;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.api.services.SchedulerService;
import org.apache.unomi.api.services.SegmentService;
import org.apache.unomi.api.utils.ParserHelper;
import org.apache.unomi.persistence.spi.CustomObjectMapper;
import org.apache.unomi.persistence.spi.PersistenceService;
import org.apache.unomi.persistence.spi.PropertyHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileServiceImpl
implements ProfileService,
SynchronousBundleListener {
    private static final Logger logger = LoggerFactory.getLogger((String)ProfileServiceImpl.class.getName());
    private BundleContext bundleContext;
    private PersistenceService persistenceService;
    private DefinitionsService definitionsService;
    private SchedulerService schedulerService;
    private SegmentService segmentService;
    private Condition purgeProfileQuery;
    private Integer purgeProfileExistTime = 0;
    private Integer purgeProfileInactiveTime = 0;
    private Integer purgeSessionsAndEventsTime = 0;
    private Integer purgeProfileInterval = 0;
    private long propertiesRefreshInterval = 10000L;
    private PropertyTypes propertyTypes;
    private boolean forceRefreshOnSave = false;

    public ProfileServiceImpl() {
        logger.info("Initializing profile service...");
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setDefinitionsService(DefinitionsService definitionsService) {
        this.definitionsService = definitionsService;
    }

    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public void setSegmentService(SegmentService segmentService) {
        this.segmentService = segmentService;
    }

    public void setForceRefreshOnSave(boolean forceRefreshOnSave) {
        this.forceRefreshOnSave = forceRefreshOnSave;
    }

    public void setPropertiesRefreshInterval(long propertiesRefreshInterval) {
        this.propertiesRefreshInterval = propertiesRefreshInterval;
    }

    public void postConstruct() {
        logger.debug("postConstruct {" + this.bundleContext.getBundle() + "}");
        this.loadPropertyTypesFromPersistence();
        this.processBundleStartup(this.bundleContext);
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (bundle.getBundleContext() == null || bundle.getBundleId() == this.bundleContext.getBundle().getBundleId()) continue;
            this.processBundleStartup(bundle.getBundleContext());
        }
        this.bundleContext.addBundleListener((BundleListener)this);
        this.initializePurge();
        this.schedulePropertyTypeLoad();
        logger.info("Profile service initialized.");
    }

    public void preDestroy() {
        this.bundleContext.removeBundleListener((BundleListener)this);
        logger.info("Profile service shutdown.");
    }

    private void processBundleStartup(BundleContext bundleContext) {
        if (bundleContext == null) {
            return;
        }
        this.loadPredefinedPersonas(bundleContext);
        this.loadPredefinedPropertyTypes(bundleContext);
    }

    private void processBundleStop(BundleContext bundleContext) {
    }

    public void setPurgeProfileExistTime(Integer purgeProfileExistTime) {
        this.purgeProfileExistTime = purgeProfileExistTime;
    }

    public void setPurgeProfileInactiveTime(Integer purgeProfileInactiveTime) {
        this.purgeProfileInactiveTime = purgeProfileInactiveTime;
    }

    public void setPurgeSessionsAndEventsTime(Integer purgeSessionsAndEventsTime) {
        this.purgeSessionsAndEventsTime = purgeSessionsAndEventsTime;
    }

    public void setPurgeProfileInterval(Integer purgeProfileInterval) {
        this.purgeProfileInterval = purgeProfileInterval;
    }

    private void schedulePropertyTypeLoad() {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                ProfileServiceImpl.this.reloadPropertyTypes(false);
            }
        };
        this.schedulerService.getScheduleExecutorService().scheduleAtFixedRate(task, 10000L, this.propertiesRefreshInterval, TimeUnit.MILLISECONDS);
        logger.info("Scheduled task for property type loading each 10s");
    }

    public void reloadPropertyTypes(boolean refresh) {
        try {
            if (refresh) {
                this.persistenceService.refresh();
            }
            this.loadPropertyTypesFromPersistence();
        }
        catch (Throwable t) {
            logger.error("Error loading property types from persistence back-end", t);
        }
    }

    private void loadPropertyTypesFromPersistence() {
        try {
            this.propertyTypes = new PropertyTypes(this.persistenceService.getAllItems(PropertyType.class, 0, -1, "rank").getList());
        }
        catch (Exception e) {
            logger.error("Error loading property types from persistence service", (Throwable)e);
        }
    }

    private void initializePurge() {
        logger.info("Profile purge: Initializing");
        if (this.purgeProfileInactiveTime > 0 || this.purgeProfileExistTime > 0 || this.purgeSessionsAndEventsTime > 0) {
            if (this.purgeProfileInactiveTime > 0) {
                logger.info("Profile purge: Profile with no visits since {} days, will be purged", (Object)this.purgeProfileInactiveTime);
            }
            if (this.purgeProfileExistTime > 0) {
                logger.info("Profile purge: Profile created since {} days, will be purged", (Object)this.purgeProfileExistTime);
            }
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    try {
                        long purgeStartTime = System.currentTimeMillis();
                        logger.debug("Profile purge: Purge triggered");
                        if (ProfileServiceImpl.this.purgeProfileQuery == null) {
                            ConditionType profilePropertyConditionType = ProfileServiceImpl.this.definitionsService.getConditionType("profilePropertyCondition");
                            ConditionType booleanCondition = ProfileServiceImpl.this.definitionsService.getConditionType("booleanCondition");
                            if (profilePropertyConditionType == null || booleanCondition == null) {
                                return;
                            }
                            ProfileServiceImpl.this.purgeProfileQuery = new Condition(booleanCondition);
                            ProfileServiceImpl.this.purgeProfileQuery.setParameter("operator", (Object)"or");
                            ArrayList<Condition> subConditions = new ArrayList<Condition>();
                            if (ProfileServiceImpl.this.purgeProfileInactiveTime > 0) {
                                Condition inactiveTimeCondition = new Condition(profilePropertyConditionType);
                                inactiveTimeCondition.setParameter("propertyName", (Object)"properties.lastVisit");
                                inactiveTimeCondition.setParameter("comparisonOperator", (Object)"lessThanOrEqualTo");
                                inactiveTimeCondition.setParameter("propertyValueDateExpr", (Object)("now-" + ProfileServiceImpl.this.purgeProfileInactiveTime + "d"));
                                subConditions.add(inactiveTimeCondition);
                            }
                            if (ProfileServiceImpl.this.purgeProfileExistTime > 0) {
                                Condition existTimeCondition = new Condition(profilePropertyConditionType);
                                existTimeCondition.setParameter("propertyName", (Object)"properties.firstVisit");
                                existTimeCondition.setParameter("comparisonOperator", (Object)"lessThanOrEqualTo");
                                existTimeCondition.setParameter("propertyValueDateExpr", (Object)("now-" + ProfileServiceImpl.this.purgeProfileExistTime + "d"));
                                subConditions.add(existTimeCondition);
                            }
                            ProfileServiceImpl.this.purgeProfileQuery.setParameter("subConditions", subConditions);
                        }
                        ProfileServiceImpl.this.persistenceService.removeByQuery(ProfileServiceImpl.this.purgeProfileQuery, Profile.class);
                        if (ProfileServiceImpl.this.purgeSessionsAndEventsTime > 0) {
                            logger.info("Monthly indexes purge: Session and events created before {} months, will be purged", (Object)ProfileServiceImpl.this.purgeSessionsAndEventsTime);
                            ProfileServiceImpl.this.persistenceService.purge(ProfileServiceImpl.this.getMonth(-ProfileServiceImpl.this.purgeSessionsAndEventsTime.intValue()).getTime());
                        }
                        logger.info("Profile purge: purge executed in {} ms", (Object)(System.currentTimeMillis() - purgeStartTime));
                    }
                    catch (Throwable t) {
                        logger.error("Error while purging profiles", t);
                    }
                }
            };
            this.schedulerService.getScheduleExecutorService().scheduleAtFixedRate(task, 1L, this.purgeProfileInterval.intValue(), TimeUnit.DAYS);
            logger.info("Profile purge: purge scheduled with an interval of {} days", (Object)this.purgeProfileInterval);
        } else {
            logger.info("Profile purge: No purge scheduled");
        }
    }

    private GregorianCalendar getMonth(int offset) {
        GregorianCalendar gc = new GregorianCalendar();
        gc = new GregorianCalendar(gc.get(1), gc.get(2), 1);
        gc.add(2, offset);
        return gc;
    }

    public long getAllProfilesCount() {
        return this.persistenceService.getAllItemsCount("profile");
    }

    public <T extends Profile> PartialList<T> search(Query query, Class<T> clazz) {
        return this.doSearch(query, clazz);
    }

    public PartialList<Session> searchSessions(Query query) {
        return this.doSearch(query, Session.class);
    }

    private <T extends Item> PartialList<T> doSearch(Query query, Class<T> clazz) {
        if (query.getScrollIdentifier() != null) {
            return this.persistenceService.continueScrollQuery(clazz, query.getScrollIdentifier(), query.getScrollTimeValidity());
        }
        if (query.getCondition() != null && this.definitionsService.resolveConditionType(query.getCondition())) {
            if (StringUtils.isNotBlank((CharSequence)query.getText())) {
                return this.persistenceService.queryFullText(query.getText(), query.getCondition(), query.getSortby(), clazz, query.getOffset(), query.getLimit());
            }
            return this.persistenceService.query(query.getCondition(), query.getSortby(), clazz, query.getOffset(), query.getLimit(), query.getScrollTimeValidity());
        }
        if (StringUtils.isNotBlank((CharSequence)query.getText())) {
            return this.persistenceService.queryFullText(query.getText(), query.getSortby(), clazz, query.getOffset(), query.getLimit());
        }
        return this.persistenceService.getAllItems(clazz, query.getOffset(), query.getLimit(), query.getSortby(), query.getScrollTimeValidity());
    }

    public boolean setPropertyType(PropertyType property) {
        PropertyType previousProperty = (PropertyType)this.persistenceService.load(property.getItemId(), PropertyType.class);
        boolean result = false;
        if (previousProperty == null) {
            result = this.persistenceService.save((Item)property);
            this.propertyTypes = this.propertyTypes.with(property);
        } else if (this.merge(previousProperty, property)) {
            result = this.persistenceService.save((Item)previousProperty);
            this.propertyTypes = this.propertyTypes.with(previousProperty);
        }
        this.persistenceService.setPropertyMapping(property, "profile");
        return result;
    }

    public boolean deletePropertyType(String propertyId) {
        boolean result = this.persistenceService.remove(propertyId, PropertyType.class);
        this.propertyTypes = this.propertyTypes.without(propertyId);
        return result;
    }

    public Set<PropertyType> getExistingProperties(String tag, String itemType) {
        return this.getExistingProperties(tag, itemType, false);
    }

    public Set<PropertyType> getExistingProperties(String tag, String itemType, boolean systemTag) {
        LinkedHashSet<PropertyType> filteredProperties = new LinkedHashSet<PropertyType>();
        Set<PropertyType> profileProperties = systemTag ? this.getPropertyTypeBySystemTag(tag) : this.getPropertyTypeByTag(tag);
        Map itemMapping = this.persistenceService.getPropertiesMapping(itemType);
        if (itemMapping == null || itemMapping.isEmpty() || itemMapping.get("properties") == null || ((Map)itemMapping.get("properties")).get("properties") == null) {
            return filteredProperties;
        }
        Map propMapping = (Map)((Map)itemMapping.get("properties")).get("properties");
        for (PropertyType propertyType : profileProperties) {
            if (!propMapping.containsKey(propertyType.getMetadata().getId())) continue;
            filteredProperties.add(propertyType);
        }
        return filteredProperties;
    }

    public String exportProfilesPropertiesToCsv(Query query) {
        StringBuilder sb = new StringBuilder();
        Set<PropertyType> propertyTypes = this.getExistingProperties("profileProperties", "profile");
        PartialList<Profile> profiles = this.search(query, Profile.class);
        LinkedHashMap<String, PropertyType> propertyTypesById = new LinkedHashMap<String, PropertyType>();
        for (PropertyType propertyType : propertyTypes) {
            propertyTypesById.put(propertyType.getMetadata().getId(), propertyType);
        }
        for (Profile profile : profiles.getList()) {
            for (String string : profile.getProperties().keySet()) {
                if (propertyTypesById.containsKey(string)) continue;
                propertyTypesById.put(string, null);
            }
        }
        sb.append("profileId;");
        for (String propertyId : ((HashMap)propertyTypesById).keySet()) {
            sb.append(propertyId);
            sb.append(";");
        }
        sb.append("segments\n");
        for (Profile profile : profiles.getList()) {
            sb.append(profile.getItemId());
            sb.append(";");
            for (Map.Entry entry : ((HashMap)propertyTypesById).entrySet()) {
                String propertyId = (String)entry.getKey();
                if (profile.getProperties().get(propertyId) != null) {
                    this.handleExportProperty(sb, profile.getProperties().get(propertyId), (PropertyType)entry.getValue());
                } else {
                    sb.append("");
                }
                sb.append(";");
            }
            ArrayList<String> segmentNames = new ArrayList<String>();
            for (String segment : profile.getSegments()) {
                Segment s = this.segmentService.getSegmentDefinition(segment);
                segmentNames.add(this.csvEncode(s.getMetadata().getName()));
            }
            sb.append(this.csvEncode(StringUtils.join(segmentNames, (String)",")));
            sb.append('\n');
        }
        return sb.toString();
    }

    private void handleExportProperty(StringBuilder sb, Object propertyValue, PropertyType propertyType) {
        if (propertyValue instanceof Collection && propertyType != null && propertyType.isMultivalued() != null && propertyType.isMultivalued().booleanValue()) {
            Collection propertyValues = (Collection)propertyValue;
            ArrayList<String> encodedValues = new ArrayList<String>(propertyValues.size());
            for (Object value : propertyValues) {
                encodedValues.add(this.csvEncode(value.toString()));
            }
            sb.append(this.csvEncode(StringUtils.join(encodedValues, (String)",")));
        } else {
            sb.append(this.csvEncode(propertyValue.toString()));
        }
    }

    private String csvEncode(String input) {
        if (StringUtils.containsAny((CharSequence)input, (char[])new char[]{'\n', '\"', ','})) {
            return "\"" + input.replace("\"", "\"\"") + "\"";
        }
        return input;
    }

    public PartialList<Profile> findProfilesByPropertyValue(String propertyName, String propertyValue, int offset, int size, String sortBy) {
        return this.persistenceService.query(propertyName, propertyValue, sortBy, Profile.class, offset, size);
    }

    public Profile load(String profileId) {
        ProfileAlias profileAlias = (ProfileAlias)this.persistenceService.load(profileId, ProfileAlias.class);
        if (profileAlias != null) {
            profileId = profileAlias.getProfileID();
        }
        return (Profile)this.persistenceService.load(profileId, Profile.class);
    }

    public Profile save(Profile profile) {
        return this.save(profile, this.forceRefreshOnSave);
    }

    public void addAliasToProfile(String profileID, String alias, String clientID) {
        if (Objects.equals(alias, profileID)) {
            throw new IllegalArgumentException("Alias cannot be created on itself, please use an alias different from the profile ID");
        }
        ProfileAlias profileAlias = (ProfileAlias)this.persistenceService.load(alias, ProfileAlias.class);
        if (profileAlias != null && !Objects.equals(profileAlias.getProfileID(), profileID)) {
            throw new IllegalArgumentException("Alias \"" + alias + "\" already used by profile with ID = \"" + profileAlias.getProfileID() + "\"");
        }
        if (profileAlias == null) {
            profileAlias = new ProfileAlias();
            profileAlias.setItemId(alias);
            profileAlias.setItemType("profileAlias");
            profileAlias.setProfileID(profileID);
            profileAlias.setClientID(clientID);
            Date creationTime = new Date();
            profileAlias.setCreationTime(creationTime);
            profileAlias.setModifiedTime(creationTime);
            this.persistenceService.save((Item)profileAlias);
        }
    }

    public ProfileAlias removeAliasFromProfile(String profileID, String alias, String clientID) {
        Condition profileIDCondition = new Condition(this.definitionsService.getConditionType("profileAliasesPropertyCondition"));
        profileIDCondition.setParameter("propertyName", (Object)"profileID.keyword");
        profileIDCondition.setParameter("comparisonOperator", (Object)"equals");
        profileIDCondition.setParameter("propertyValue", (Object)profileID);
        Condition clientIDCondition = new Condition(this.definitionsService.getConditionType("profileAliasesPropertyCondition"));
        clientIDCondition.setParameter("propertyName", (Object)"clientID.keyword");
        clientIDCondition.setParameter("comparisonOperator", (Object)"equals");
        clientIDCondition.setParameter("propertyValue", (Object)clientID);
        Condition aliasCondition = new Condition(this.definitionsService.getConditionType("profileAliasesPropertyCondition"));
        aliasCondition.setParameter("propertyName", (Object)"itemId");
        aliasCondition.setParameter("comparisonOperator", (Object)"equals");
        aliasCondition.setParameter("propertyValue", (Object)alias);
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        conditions.add(profileIDCondition);
        conditions.add(clientIDCondition);
        conditions.add(aliasCondition);
        Condition condition = new Condition(this.definitionsService.getConditionType("booleanCondition"));
        condition.setParameter("operator", (Object)"and");
        condition.setParameter("subConditions", conditions);
        List profileAliases = this.persistenceService.query(condition, null, ProfileAlias.class);
        if (profileAliases.size() == 1 && this.persistenceService.removeByQuery(condition, ProfileAlias.class)) {
            return (ProfileAlias)profileAliases.get(0);
        }
        return null;
    }

    public PartialList<ProfileAlias> findProfileAliases(String profileId, int offset, int size, String sortBy) {
        Condition condition = new Condition(this.definitionsService.getConditionType("profileAliasesPropertyCondition"));
        condition.setParameter("propertyName", (Object)"profileID.keyword");
        condition.setParameter("comparisonOperator", (Object)"equals");
        condition.setParameter("propertyValue", (Object)profileId);
        return this.persistenceService.query(condition, sortBy, ProfileAlias.class, offset, size);
    }

    private Profile save(Profile profile, boolean forceRefresh) {
        if (profile.getItemId() == null) {
            return null;
        }
        profile.setSystemProperty("lastUpdated", (Object)new Date());
        if (this.persistenceService.save((Item)profile)) {
            if (forceRefresh) {
                this.persistenceService.refreshIndex(Profile.class, null);
            }
            return profile;
        }
        return null;
    }

    public Profile saveOrMerge(Profile profile) {
        Profile previousProfile = (Profile)this.persistenceService.load(profile.getItemId(), Profile.class);
        profile.setSystemProperty("lastUpdated", (Object)new Date());
        if (previousProfile == null) {
            if (this.persistenceService.save((Item)profile)) {
                return profile;
            }
            return null;
        }
        if (this.merge(previousProfile, profile)) {
            if (this.persistenceService.save((Item)previousProfile)) {
                return previousProfile;
            }
            return null;
        }
        return null;
    }

    public Persona savePersona(Persona profile) {
        profile.setSystemProperty("lastUpdated", (Object)new Date());
        if (this.persistenceService.load(profile.getItemId(), Persona.class) == null) {
            PersonaSession session = new PersonaSession(UUID.randomUUID().toString(), (Profile)profile, new Date());
            this.persistenceService.save((Item)profile);
            this.persistenceService.save((Item)session);
        } else {
            this.persistenceService.save((Item)profile);
        }
        return (Persona)this.persistenceService.load(profile.getItemId(), Persona.class);
    }

    public void delete(String profileId, boolean persona) {
        if (persona) {
            this.persistenceService.remove(profileId, Persona.class);
        } else {
            Condition removeAliasesCondition = new Condition(this.definitionsService.getConditionType("profileAliasesPropertyCondition"));
            removeAliasesCondition.setParameter("propertyName", (Object)"profileID");
            removeAliasesCondition.setParameter("comparisonOperator", (Object)"equals");
            removeAliasesCondition.setParameter("propertyValue", (Object)profileId);
            this.persistenceService.removeByQuery(removeAliasesCondition, ProfileAlias.class);
            this.persistenceService.remove(profileId, Profile.class);
        }
    }

    public Profile mergeProfiles(Profile masterProfile, List<Profile> profilesToMerge) {
        boolean bl;
        ArrayList<Profile> filteredProfilesToMerge = new ArrayList<Profile>();
        for (Profile profile : profilesToMerge) {
            if (profile.getItemId().equals(masterProfile.getItemId())) continue;
            filteredProfilesToMerge.add(profile);
        }
        if (filteredProfilesToMerge.isEmpty()) {
            return masterProfile;
        }
        profilesToMerge = filteredProfilesToMerge;
        LinkedHashSet allProfileProperties = new LinkedHashSet();
        for (Profile profile : profilesToMerge) {
            Set flatNestedPropertiesKeys = PropertyHelper.flatten((Map)profile.getProperties()).keySet();
            allProfileProperties.addAll(flatNestedPropertiesKeys);
        }
        Collection<PropertyType> collection = this.getTargetPropertyTypes("profiles");
        HashMap<String, PropertyType> profilePropertyTypeById = new HashMap<String, PropertyType>();
        for (PropertyType propertyType : collection) {
            profilePropertyTypeById.put(propertyType.getMetadata().getId(), propertyType);
        }
        TreeSet<String> profileIdsToMerge = new TreeSet<String>();
        for (Profile profileToMerge : profilesToMerge) {
            profileIdsToMerge.add(profileToMerge.getItemId());
        }
        logger.info("Merging profiles " + profileIdsToMerge + " into profile " + masterProfile.getItemId());
        boolean bl2 = false;
        for (String profileProperty : allProfileProperties) {
            PropertyMergeStrategyType propertyMergeStrategyType;
            PropertyType propertyType = (PropertyType)profilePropertyTypeById.get(profileProperty);
            String propertyMergeStrategyId = "defaultMergeStrategy";
            if (propertyType != null && propertyType.getMergeStrategy() != null && propertyMergeStrategyId.length() > 0) {
                propertyMergeStrategyId = propertyType.getMergeStrategy();
            }
            if ((propertyMergeStrategyType = this.definitionsService.getPropertyMergeStrategyType(propertyMergeStrategyId)) == null) {
                if (propertyMergeStrategyId.equals("defaultMergeStrategy")) {
                    logger.warn("Couldn't resolve default strategy, ignoring property merge for property " + profileProperty);
                    continue;
                }
                logger.warn("Couldn't resolve strategy " + propertyMergeStrategyId + " for property " + profileProperty + ", using default strategy instead");
                propertyMergeStrategyId = "defaultMergeStrategy";
                propertyMergeStrategyType = this.definitionsService.getPropertyMergeStrategyType(propertyMergeStrategyId);
            }
            try {
                Collection matchingPropertyMergeStrategyExecutors = this.bundleContext.getServiceReferences(PropertyMergeStrategyExecutor.class, propertyMergeStrategyType.getFilter());
                for (ServiceReference propertyMergeStrategyExecutorReference : matchingPropertyMergeStrategyExecutors) {
                    PropertyMergeStrategyExecutor propertyMergeStrategyExecutor = (PropertyMergeStrategyExecutor)this.bundleContext.getService(propertyMergeStrategyExecutorReference);
                    var8_13 |= propertyMergeStrategyExecutor.mergeProperty(profileProperty, propertyType, profilesToMerge, masterProfile);
                }
            }
            catch (InvalidSyntaxException e) {
                logger.error("Error retrieving strategy implementation", (Throwable)e);
            }
        }
        for (Profile profile : profilesToMerge) {
            boolean bl3;
            bl3 = this.mergeSystemProperties(masterProfile.getSystemProperties(), profile.getSystemProperties()) || bl3;
        }
        for (Profile profile : profilesToMerge) {
            if (profile.getSegments() == null || profile.getSegments().size() <= 0) continue;
            masterProfile.getSegments().addAll(profile.getSegments());
            boolean bl4 = true;
        }
        for (Profile profile : profilesToMerge) {
            if (profile.getConsents() == null || profile.getConsents().size() <= 0) continue;
            for (String consentId : profile.getConsents().keySet()) {
                if (masterProfile.getConsents().containsKey(consentId)) {
                    if (((Consent)masterProfile.getConsents().get(consentId)).getRevokeDate().before(new Date())) {
                        masterProfile.getConsents().remove(consentId);
                        bl = true;
                        continue;
                    }
                    if (!((Consent)masterProfile.getConsents().get(consentId)).getStatusDate().before(((Consent)profile.getConsents().get(consentId)).getStatusDate())) continue;
                    masterProfile.getConsents().replace(consentId, profile.getConsents().get(consentId));
                    bl = true;
                    continue;
                }
                masterProfile.getConsents().put(consentId, profile.getConsents().get(consentId));
                bl = true;
            }
        }
        if (bl) {
            this.persistenceService.save((Item)masterProfile);
        }
        return masterProfile;
    }

    public PartialList<Session> getProfileSessions(String profileId, String query, int offset, int size, String sortBy) {
        if (StringUtils.isNotBlank((CharSequence)query)) {
            return this.persistenceService.queryFullText("profileId", profileId, query, sortBy, Session.class, offset, size);
        }
        return this.persistenceService.query("profileId", profileId, sortBy, Session.class, offset, size);
    }

    public String getPropertyTypeMapping(String fromPropertyTypeId) {
        Collection<PropertyType> types = this.getPropertyTypeByMapping(fromPropertyTypeId);
        if (types.size() > 0) {
            return types.iterator().next().getMetadata().getId();
        }
        return null;
    }

    public Session loadSession(String sessionId, Date dateHint) {
        Session s = (Session)this.persistenceService.load(sessionId, dateHint, Session.class);
        if (s == null && dateHint != null) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(dateHint);
            if (gc.get(5) == 1) {
                gc.add(5, -1);
                s = (Session)this.persistenceService.load(sessionId, gc.getTime(), Session.class);
            }
        }
        return s;
    }

    public Session saveSession(Session session) {
        if (session.getItemId() == null) {
            return null;
        }
        if (session.getProfile() != null && session.getProfile().getProperties() != null) {
            session.getProfile().setProperties(this.removePersonalIdentifiersFromSessionProfile(session.getProfile().getProperties()));
        }
        return this.persistenceService.save((Item)session) ? session : null;
    }

    private Map removePersonalIdentifiersFromSessionProfile(Map<String, Object> profileProperties) {
        Set<PropertyType> personalIdsProps = this.getPropertyTypeBySystemTag("personalIdentifierProperties");
        ArrayList personalIdsPropsNames = new ArrayList();
        personalIdsProps.forEach(propType -> personalIdsPropsNames.add(propType.getMetadata().getId()));
        HashSet propsToRemove = new HashSet();
        profileProperties.keySet().forEach(propKey -> {
            if (personalIdsPropsNames.contains(propKey)) {
                propsToRemove.add(propKey);
            }
        });
        propsToRemove.forEach(propId -> profileProperties.remove(propId));
        return profileProperties;
    }

    public PartialList<Session> findProfileSessions(String profileId) {
        return this.persistenceService.query("profileId", profileId, "timeStamp:desc", Session.class, 0, 50);
    }

    public void removeProfileSessions(String profileId) {
        Condition profileCondition = new Condition();
        profileCondition.setConditionType(this.definitionsService.getConditionType("sessionPropertyCondition"));
        profileCondition.setParameter("propertyName", (Object)"profileId");
        profileCondition.setParameter("comparisonOperator", (Object)"equals");
        profileCondition.setParameter("propertyValue", (Object)profileId);
        this.persistenceService.removeByQuery(profileCondition, Session.class);
    }

    public boolean matchCondition(Condition condition, Profile profile, Session session) {
        ParserHelper.resolveConditionType((DefinitionsService)this.definitionsService, (Condition)condition, (String)("profile " + profile.getItemId() + " matching"));
        if (condition.getConditionTypeId().equals("booleanCondition")) {
            List subConditions = (List)condition.getParameter("subConditions");
            boolean isAnd = "and".equals(condition.getParameter("operator"));
            for (Condition subCondition : subConditions) {
                if (isAnd && !this.matchCondition(subCondition, profile, session)) {
                    return false;
                }
                if (isAnd || !this.matchCondition(subCondition, profile, session)) continue;
                return true;
            }
            return subConditions.size() > 0 && isAnd;
        }
        Condition profileCondition = this.definitionsService.extractConditionBySystemTag(condition, "profileCondition");
        Condition sessionCondition = this.definitionsService.extractConditionBySystemTag(condition, "sessionCondition");
        if (profileCondition != null && !this.persistenceService.testMatch(profileCondition, (Item)profile)) {
            return false;
        }
        return sessionCondition == null || this.persistenceService.testMatch(sessionCondition, (Item)session);
    }

    public void batchProfilesUpdate(BatchUpdate update) {
        ParserHelper.resolveConditionType((DefinitionsService)this.definitionsService, (Condition)update.getCondition(), (String)("batch update on property " + update.getPropertyName()));
        List profiles = this.persistenceService.query(update.getCondition(), null, Profile.class);
        for (Profile profile : profiles) {
            if (!PropertyHelper.setProperty((Object)profile, (String)update.getPropertyName(), (Object)update.getPropertyValue(), (String)update.getStrategy())) continue;
            this.save(profile);
        }
    }

    public Persona loadPersona(String personaId) {
        return (Persona)this.persistenceService.load(personaId, Persona.class);
    }

    public PersonaWithSessions loadPersonaWithSessions(String personaId) {
        Persona persona = (Persona)this.persistenceService.load(personaId, Persona.class);
        if (persona == null) {
            return null;
        }
        List sessions = this.persistenceService.query("profileId", persona.getItemId(), "timeStamp:desc", PersonaSession.class);
        return new PersonaWithSessions(persona, sessions);
    }

    public Persona createPersona(String personaId) {
        Persona newPersona = new Persona(personaId);
        PersonaSession session = new PersonaSession(UUID.randomUUID().toString(), (Profile)newPersona, new Date());
        this.persistenceService.save((Item)newPersona);
        this.persistenceService.save((Item)session);
        return newPersona;
    }

    public Collection<PropertyType> getTargetPropertyTypes(String target) {
        if (target == null) {
            return null;
        }
        List<PropertyType> result = this.propertyTypes.getByTarget(target);
        if (result == null) {
            return new ArrayList<PropertyType>();
        }
        return result;
    }

    public Map<String, Collection<PropertyType>> getTargetPropertyTypes() {
        return new HashMap<String, Collection<PropertyType>>(this.propertyTypes.getAllByTarget());
    }

    public Set<PropertyType> getPropertyTypeByTag(String tag) {
        if (tag == null) {
            return null;
        }
        List<PropertyType> result = this.propertyTypes.getByTag(tag);
        if (result == null) {
            return new LinkedHashSet<PropertyType>();
        }
        return new LinkedHashSet<PropertyType>(result);
    }

    public Set<PropertyType> getPropertyTypeBySystemTag(String tag) {
        if (tag == null) {
            return null;
        }
        List<PropertyType> result = this.propertyTypes.getBySystemTag(tag);
        if (result == null) {
            return new LinkedHashSet<PropertyType>();
        }
        return new LinkedHashSet<PropertyType>(result);
    }

    public Collection<PropertyType> getPropertyTypeByMapping(String propertyName) {
        TreeSet<PropertyType> l = new TreeSet<PropertyType>(new Comparator<PropertyType>(){

            @Override
            public int compare(PropertyType o1, PropertyType o2) {
                if (o1.getRank() == o2.getRank()) {
                    return o1.getMetadata().getName().compareTo(o1.getMetadata().getName());
                }
                if (o1.getRank() < o2.getRank()) {
                    return -1;
                }
                return 1;
            }
        });
        for (PropertyType propertyType : this.propertyTypes.getAll()) {
            if (propertyType.getAutomaticMappingsFrom() == null || !propertyType.getAutomaticMappingsFrom().contains(propertyName)) continue;
            l.add(propertyType);
        }
        return l;
    }

    public PropertyType getPropertyType(String id) {
        return this.propertyTypes.get(id);
    }

    public PartialList<Session> getPersonaSessions(String personaId, int offset, int size, String sortBy) {
        return this.persistenceService.query("profileId", personaId, sortBy, Session.class, offset, size);
    }

    public PersonaWithSessions savePersonaWithSessions(PersonaWithSessions personaToSave) {
        if (personaToSave != null) {
            if (personaToSave.getPersona().getItemId() == null) {
                personaToSave.getPersona().setItemId("persona-" + UUID.randomUUID().toString());
            }
            boolean savedPersona = this.persistenceService.save((Item)personaToSave.getPersona());
            List sessions = personaToSave.getSessions();
            for (PersonaSession session : sessions) {
                if (session.getItemId() == null) {
                    session.setItemId(UUID.randomUUID().toString());
                }
                session.setProfile((Profile)personaToSave.getPersona());
                this.persistenceService.save((Item)session);
            }
            return personaToSave;
        }
        return null;
    }

    public void setPropertyTypeTarget(URL predefinedPropertyTypeURL, PropertyType propertyType) {
        String[] splitPath;
        String target;
        if (StringUtils.isBlank((CharSequence)propertyType.getTarget()) && StringUtils.isNotBlank((CharSequence)(target = (splitPath = predefinedPropertyTypeURL.getPath().split("/"))[4]))) {
            propertyType.setTarget(target);
        }
    }

    private void loadPredefinedPersonas(BundleContext bundleContext) {
        if (bundleContext == null) {
            return;
        }
        Enumeration predefinedPersonaEntries = bundleContext.getBundle().findEntries("META-INF/cxs/personas", "*.json", true);
        if (predefinedPersonaEntries == null) {
            return;
        }
        while (predefinedPersonaEntries.hasMoreElements()) {
            URL predefinedPersonaURL = (URL)predefinedPersonaEntries.nextElement();
            logger.debug("Found predefined persona at " + predefinedPersonaURL + ", loading... ");
            try {
                PersonaWithSessions persona = (PersonaWithSessions)CustomObjectMapper.getObjectMapper().readValue(predefinedPersonaURL, PersonaWithSessions.class);
                String itemId = persona.getPersona().getItemId();
                this.persistenceService.save((Item)persona.getPersona());
                List sessions = persona.getSessions();
                for (PersonaSession session : sessions) {
                    session.setProfile((Profile)persona.getPersona());
                    this.persistenceService.save((Item)session);
                }
                logger.info("Predefined persona with id {} registered", (Object)itemId);
            }
            catch (IOException e) {
                logger.error("Error while loading persona " + predefinedPersonaURL, (Throwable)e);
            }
        }
    }

    private void loadPredefinedPropertyTypes(BundleContext bundleContext) {
        Enumeration predefinedPropertyTypeEntries = bundleContext.getBundle().findEntries("META-INF/cxs/properties", "*.json", true);
        if (predefinedPropertyTypeEntries == null) {
            return;
        }
        ArrayList<PropertyType> bundlePropertyTypes = new ArrayList<PropertyType>();
        while (predefinedPropertyTypeEntries.hasMoreElements()) {
            URL predefinedPropertyTypeURL = (URL)predefinedPropertyTypeEntries.nextElement();
            logger.debug("Found predefined property type at " + predefinedPropertyTypeURL + ", loading... ");
            try {
                PropertyType propertyType = (PropertyType)CustomObjectMapper.getObjectMapper().readValue(predefinedPropertyTypeURL, PropertyType.class);
                this.setPropertyTypeTarget(predefinedPropertyTypeURL, propertyType);
                this.persistenceService.save((Item)propertyType);
                bundlePropertyTypes.add(propertyType);
                logger.info("Predefined property type with id {} registered", (Object)propertyType.getMetadata().getId());
            }
            catch (IOException e) {
                logger.error("Error while loading properties " + predefinedPropertyTypeURL, (Throwable)e);
            }
        }
        this.propertyTypes = this.propertyTypes.with(bundlePropertyTypes);
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 2: {
                this.processBundleStartup(event.getBundle().getBundleContext());
                break;
            }
            case 256: {
                this.processBundleStop(event.getBundle().getBundleContext());
            }
        }
    }

    private <T> boolean merge(T target, T object) {
        if (object != null) {
            try {
                Map objectValues = PropertyUtils.describe(object);
                Map targetValues = PropertyUtils.describe(target);
                if (this.merge(targetValues, objectValues)) {
                    BeanUtils.populate(target, (Map)targetValues);
                    return true;
                }
            }
            catch (ReflectiveOperationException e) {
                logger.error("Cannot merge properties", (Throwable)e);
            }
        }
        return false;
    }

    private boolean merge(Map<String, Object> target, Map<String, Object> object) {
        boolean changed = false;
        for (Map.Entry<String, Object> newEntry : object.entrySet()) {
            if (newEntry.getValue() != null) {
                String packageName = newEntry.getValue().getClass().getPackage().getName();
                if (newEntry.getValue() instanceof Collection) {
                    target.put(newEntry.getKey(), newEntry.getValue());
                    changed = true;
                    continue;
                }
                if (newEntry.getValue() instanceof Map) {
                    Map currentMap = (Map)target.get(newEntry.getKey());
                    if (currentMap == null) {
                        target.put(newEntry.getKey(), newEntry.getValue());
                        changed = true;
                        continue;
                    }
                    changed |= this.merge(currentMap, (Map)newEntry.getValue());
                    continue;
                }
                if (StringUtils.equals((CharSequence)packageName, (CharSequence)"java.lang")) {
                    if (newEntry.getValue() == null || newEntry.getValue().equals(target.get(newEntry.getKey()))) continue;
                    target.put(newEntry.getKey(), newEntry.getValue());
                    changed = true;
                    continue;
                }
                if (newEntry.getValue().getClass().isEnum()) {
                    target.put(newEntry.getKey(), newEntry.getValue());
                    changed = true;
                    continue;
                }
                if (target.get(newEntry.getKey()) != null) {
                    changed |= this.merge(target.get(newEntry.getKey()), newEntry.getValue());
                    continue;
                }
                target.put(newEntry.getKey(), newEntry.getValue());
                changed = true;
                continue;
            }
            if (!target.containsKey(newEntry.getKey())) continue;
            target.remove(newEntry.getKey());
            changed = true;
        }
        return changed;
    }

    private boolean mergeSystemProperties(Map<String, Object> targetProperties, Map<String, Object> sourceProperties) {
        boolean changed = false;
        for (Map.Entry<String, Object> sourceProperty : sourceProperties.entrySet()) {
            if (sourceProperty.getValue() == null) continue;
            if (!targetProperties.containsKey(sourceProperty.getKey())) {
                targetProperties.put(sourceProperty.getKey(), sourceProperty.getValue());
                changed = true;
                continue;
            }
            Object targetProperty = targetProperties.get(sourceProperty.getKey());
            if (targetProperty instanceof Map && sourceProperty.getValue() instanceof Map) {
                Map mapSourceProp = (Map)sourceProperty.getValue();
                Map mapTargetProp = (Map)targetProperty;
                for (Map.Entry mapSourceEntry : mapSourceProp.entrySet()) {
                    if (mapTargetProp.containsKey(mapSourceEntry.getKey())) continue;
                    mapTargetProp.put(mapSourceEntry.getKey(), mapSourceEntry.getValue());
                    changed = true;
                }
                continue;
            }
            if (!(targetProperty instanceof Collection) || !(sourceProperty.getValue() instanceof Collection)) continue;
            Collection sourceCollection = (Collection)sourceProperty.getValue();
            Collection targetCollection = (Collection)targetProperty;
            for (Map.Entry sourceItem : sourceCollection) {
                if (targetCollection.contains(sourceItem)) continue;
                try {
                    targetCollection.add(sourceItem);
                    changed = true;
                }
                catch (Exception exception) {}
            }
        }
        return changed;
    }

    public void refresh() {
        this.reloadPropertyTypes(true);
    }

    private static class PropertyTypes {
        private List<PropertyType> allPropertyTypes;
        private Map<String, PropertyType> propertyTypesById = new HashMap<String, PropertyType>();
        private Map<String, List<PropertyType>> propertyTypesByTags = new HashMap<String, List<PropertyType>>();
        private Map<String, List<PropertyType>> propertyTypesBySystemTags = new HashMap<String, List<PropertyType>>();
        private Map<String, List<PropertyType>> propertyTypesByTarget = new HashMap<String, List<PropertyType>>();

        public PropertyTypes(List<PropertyType> allPropertyTypes) {
            this.allPropertyTypes = new ArrayList<PropertyType>(allPropertyTypes);
            this.propertyTypesById = new HashMap<String, PropertyType>();
            this.propertyTypesByTags = new HashMap<String, List<PropertyType>>();
            this.propertyTypesBySystemTags = new HashMap<String, List<PropertyType>>();
            this.propertyTypesByTarget = new HashMap<String, List<PropertyType>>();
            for (PropertyType propertyType : allPropertyTypes) {
                this.propertyTypesById.put(propertyType.getItemId(), propertyType);
                for (String propertyTypeTag : propertyType.getMetadata().getTags()) {
                    this.updateListMap(this.propertyTypesByTags, propertyType, propertyTypeTag);
                }
                for (String propertyTypeSystemTag : propertyType.getMetadata().getSystemTags()) {
                    this.updateListMap(this.propertyTypesBySystemTags, propertyType, propertyTypeSystemTag);
                }
                this.updateListMap(this.propertyTypesByTarget, propertyType, propertyType.getTarget());
            }
        }

        public List<PropertyType> getAll() {
            return this.allPropertyTypes;
        }

        public PropertyType get(String propertyId) {
            return this.propertyTypesById.get(propertyId);
        }

        public Map<String, List<PropertyType>> getAllByTarget() {
            return this.propertyTypesByTarget;
        }

        public List<PropertyType> getByTag(String tag) {
            return this.propertyTypesByTags.get(tag);
        }

        public List<PropertyType> getBySystemTag(String systemTag) {
            return this.propertyTypesBySystemTags.get(systemTag);
        }

        public List<PropertyType> getByTarget(String target) {
            return this.propertyTypesByTarget.get(target);
        }

        public PropertyTypes with(PropertyType newProperty) {
            return this.with(Collections.singletonList(newProperty));
        }

        public PropertyTypes with(List<PropertyType> newProperties) {
            HashMap<String, PropertyType> updatedProperties = new HashMap<String, PropertyType>();
            for (PropertyType property2 : newProperties) {
                if (!this.propertyTypesById.containsKey(property2.getItemId())) continue;
                updatedProperties.put(property2.getItemId(), property2);
            }
            List<PropertyType> newPropertyTypes = Stream.concat(this.allPropertyTypes.stream().map(property -> updatedProperties.getOrDefault(property.getItemId(), (PropertyType)property)), newProperties.stream().filter(property -> !this.propertyTypesById.containsKey(property.getItemId()))).collect(Collectors.toList());
            return new PropertyTypes(newPropertyTypes);
        }

        public PropertyTypes without(String propertyId) {
            List<PropertyType> newPropertyTypes = this.allPropertyTypes.stream().filter(property -> !property.getItemId().equals(propertyId)).collect(Collectors.toList());
            return new PropertyTypes(newPropertyTypes);
        }

        private void updateListMap(Map<String, List<PropertyType>> listMap, PropertyType propertyType, String key) {
            List<PropertyType> propertyTypes = listMap.get(key);
            if (propertyTypes == null) {
                propertyTypes = new ArrayList<PropertyType>();
            }
            propertyTypes.add(propertyType);
            listMap.put(key, propertyTypes);
        }
    }
}

