/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.core.event;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.karaf.cellar.core.event.Event;
import org.apache.karaf.cellar.core.event.EventHandler;
import org.apache.karaf.cellar.core.event.EventHandlerRegistry;

public class EventHandlerServiceRegistry<E extends Event>
implements EventHandlerRegistry<E> {
    private Map<Class, EventHandler> eventHandlerMap = new ConcurrentHashMap<Class, EventHandler>();

    @Override
    public EventHandler<E> getHandler(E event) {
        if (event != null) {
            Class<?> clazz = event.getClass();
            return this.eventHandlerMap.get(clazz);
        }
        return null;
    }

    public void bind(EventHandler handler) {
        if (handler != null && handler.getType() != null) {
            this.eventHandlerMap.put(handler.getType(), handler);
        }
    }

    public void unbind(EventHandler handler) {
        if (handler != null && handler.getType() != null) {
            this.eventHandlerMap.remove(handler.getType());
        }
    }
}

