/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.function;

import java.math.BigDecimal;
import java.math.MathContext;
import java.text.NumberFormat;
import java.util.Objects;
import javax.money.MonetaryAmount;
import javax.money.MonetaryOperator;

final class PermilOperator
implements MonetaryOperator {
    private static final MathContext DEFAULT_MATH_CONTEXT = PermilOperator.initDefaultMathContext();
    private static final BigDecimal ONE_THOUSAND = new BigDecimal(1000, MathContext.DECIMAL64);
    private final BigDecimal permilValue;

    private static MathContext initDefaultMathContext() {
        return MathContext.DECIMAL64;
    }

    PermilOperator(BigDecimal decimal) {
        this.permilValue = PermilOperator.calcPermil(decimal);
    }

    public MonetaryAmount apply(MonetaryAmount amount) {
        Objects.requireNonNull(amount, "Amount required.");
        return amount.multiply((Number)this.permilValue);
    }

    public String toString() {
        return NumberFormat.getInstance().format(this.permilValue.multiply(ONE_THOUSAND, DEFAULT_MATH_CONTEXT)) + " \u2030";
    }

    private static BigDecimal calcPermil(BigDecimal decimal) {
        return decimal.divide(ONE_THOUSAND, DEFAULT_MATH_CONTEXT);
    }
}

