/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.dataframe.transforms;

import java.time.Instant;
import java.util.Objects;
import org.elasticsearch.client.dataframe.transforms.DataFrameTransformCheckpointStats;
import org.elasticsearch.client.dataframe.transforms.util.TimeUtil;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;

public class DataFrameTransformCheckpointingInfo {
    public static final ParseField LAST_CHECKPOINT = new ParseField("last", "current");
    public static final ParseField NEXT_CHECKPOINT = new ParseField("next", "in_progress");
    public static final ParseField OPERATIONS_BEHIND = new ParseField("operations_behind", new String[0]);
    public static final ParseField CHANGES_LAST_DETECTED_AT = new ParseField("changes_last_detected_at", new String[0]);
    private final DataFrameTransformCheckpointStats last;
    private final DataFrameTransformCheckpointStats next;
    private final long operationsBehind;
    private final Instant changesLastDetectedAt;
    private static final ConstructingObjectParser<DataFrameTransformCheckpointingInfo, Void> LENIENT_PARSER = new ConstructingObjectParser("data_frame_transform_checkpointing_info", true, a -> {
        long behind = a[2] == null ? 0L : (Long)a[2];
        Instant changesLastDetectedAt = (Instant)a[3];
        return new DataFrameTransformCheckpointingInfo(a[0] == null ? DataFrameTransformCheckpointStats.EMPTY : (DataFrameTransformCheckpointStats)a[0], a[1] == null ? DataFrameTransformCheckpointStats.EMPTY : (DataFrameTransformCheckpointStats)a[1], behind, changesLastDetectedAt);
    });

    public DataFrameTransformCheckpointingInfo(DataFrameTransformCheckpointStats last, DataFrameTransformCheckpointStats next, long operationsBehind, Instant changesLastDetectedAt) {
        this.last = Objects.requireNonNull(last);
        this.next = Objects.requireNonNull(next);
        this.operationsBehind = operationsBehind;
        this.changesLastDetectedAt = changesLastDetectedAt;
    }

    public DataFrameTransformCheckpointStats getLast() {
        return this.last;
    }

    public DataFrameTransformCheckpointStats getNext() {
        return this.next;
    }

    public long getOperationsBehind() {
        return this.operationsBehind;
    }

    @Nullable
    public Instant getChangesLastDetectedAt() {
        return this.changesLastDetectedAt;
    }

    public static DataFrameTransformCheckpointingInfo fromXContent(XContentParser p) {
        return LENIENT_PARSER.apply(p, null);
    }

    public int hashCode() {
        return Objects.hash(this.last, this.next, this.operationsBehind, this.changesLastDetectedAt);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DataFrameTransformCheckpointingInfo that = (DataFrameTransformCheckpointingInfo)other;
        return Objects.equals(this.last, that.last) && Objects.equals(this.next, that.next) && this.operationsBehind == that.operationsBehind && Objects.equals(this.changesLastDetectedAt, that.changesLastDetectedAt);
    }

    static {
        LENIENT_PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> DataFrameTransformCheckpointStats.fromXContent(p), LAST_CHECKPOINT);
        LENIENT_PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> DataFrameTransformCheckpointStats.fromXContent(p), NEXT_CHECKPOINT);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), OPERATIONS_BEHIND);
        LENIENT_PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> TimeUtil.parseTimeFieldToInstant(p, CHANGES_LAST_DETECTED_AT.getPreferredName()), CHANGES_LAST_DETECTED_AT, ObjectParser.ValueType.VALUE);
    }
}

