/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import groovyx.net.http.ChainedHttpConfig;
import groovyx.net.http.FromServer;
import groovyx.net.http.HttpConfig;
import groovyx.net.http.ToServer;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public class Safe {
    public static boolean register(HttpConfig config, Supplier<Boolean> shouldRegister, List<String> contentTypes, Supplier<BiConsumer<ChainedHttpConfig, ToServer>> encoderSupplier, Supplier<BiFunction<ChainedHttpConfig, FromServer, Object>> parserSupplier) {
        if (shouldRegister.get().booleanValue()) {
            config.getRequest().encoder(contentTypes, encoderSupplier.get());
            config.getResponse().parser(contentTypes, parserSupplier.get());
            return true;
        }
        return false;
    }

    public static boolean register(HttpConfig config, Supplier<Boolean> shouldRegister, String contentType, Supplier<BiConsumer<ChainedHttpConfig, ToServer>> encoderSupplier, Supplier<BiFunction<ChainedHttpConfig, FromServer, Object>> parserSupplier) {
        return Safe.register(config, shouldRegister, Collections.singletonList(contentType), encoderSupplier, parserSupplier);
    }

    public static Supplier<Boolean> ifClassIsLoaded(String className) {
        return () -> {
            try {
                Class.forName(className);
                return true;
            }
            catch (ClassNotFoundException cnfe) {
                return false;
            }
        };
    }
}

