/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal.model;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.war.internal.model.WebAppInitParam;

public class WebAppFilter {
    private String filterName;
    private String filterClassName;
    private Filter filter;
    private final List<WebAppInitParam> initParams;
    private final Set<String> urlPatterns;
    private final Set<String> servletNames;
    private final EnumSet<DispatcherType> dispatcherTypes = EnumSet.noneOf(DispatcherType.class);
    private Class<? extends Filter> filterClass;
    private Boolean asyncSupported;

    public WebAppFilter() {
        this.urlPatterns = new HashSet<String>();
        this.servletNames = new HashSet<String>();
        this.initParams = new ArrayList<WebAppInitParam>();
    }

    public String getFilterName() {
        return this.filterName;
    }

    public void setFilterName(String filterName) {
        NullArgumentException.validateNotNull(filterName, "Filter name");
        this.filterName = filterName;
        WebAppInitParam initParam = new WebAppInitParam();
        initParam.setParamName("filter-name");
        initParam.setParamValue(filterName);
        this.initParams.add(initParam);
    }

    public String getFilterClass() {
        return this.filterClassName;
    }

    public void setFilterClass(String filterClass) {
        NullArgumentException.validateNotNull(filterClass, "Filter class");
        this.filterClassName = filterClass;
    }

    public void setFilterClass(Class<? extends Filter> filterClass) {
        NullArgumentException.validateNotNull(filterClass, "Filter class");
        this.filterClass = filterClass;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public String[] getUrlPatterns() {
        return this.urlPatterns.toArray(new String[this.urlPatterns.size()]);
    }

    public void addUrlPattern(String urlPattern) {
        NullArgumentException.validateNotEmpty(urlPattern, "Url pattern");
        this.urlPatterns.add(urlPattern);
    }

    public String[] getServletNames() {
        return this.servletNames.toArray(new String[this.servletNames.size()]);
    }

    public void addServletName(String servletName) {
        NullArgumentException.validateNotEmpty(servletName, "Servlet name");
        this.servletNames.add(servletName);
    }

    public void addDispatcherType(DispatcherType dispatcherType) {
        NullArgumentException.validateNotNull(dispatcherType, "DispatcherType");
        this.dispatcherTypes.add(dispatcherType);
    }

    public EnumSet<DispatcherType> getDispatcherTypes() {
        return this.dispatcherTypes;
    }

    public void addInitParam(WebAppInitParam param) {
        NullArgumentException.validateNotNull(param, "Init param");
        NullArgumentException.validateNotNull(param.getParamName(), "Init param name");
        NullArgumentException.validateNotNull(param.getParamValue(), "Init param value");
        this.initParams.add(param);
    }

    public WebAppInitParam[] getInitParams() {
        return this.initParams.toArray(new WebAppInitParam[this.initParams.size()]);
    }

    public void setAsyncSupported(Boolean asyncSupported) {
        this.asyncSupported = asyncSupported;
    }

    public Boolean getAsyncSupported() {
        return this.asyncSupported;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "filterName=" + this.filterName + ",filterClassName=" + this.filterClassName + ",urlPatterns=" + this.urlPatterns + ",servletNames=" + this.servletNames + "}";
    }
}

