/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.cloud;

import org.apache.camel.CamelContext;
import org.apache.camel.cloud.ServiceRegistry;
import org.apache.camel.impl.cloud.ServiceRegistrationRoutePolicy;
import org.apache.camel.impl.cloud.ServiceRegistrySelectors;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.spi.RoutePolicyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRegistrationRoutePolicyFactory
implements RoutePolicyFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceRegistrationRoutePolicyFactory.class);
    private final ServiceRegistry.Selector serviceRegistrySelector;
    private final ServiceRegistry serviceRegistry;

    public ServiceRegistrationRoutePolicyFactory() {
        this(null, ServiceRegistrySelectors.DEFAULT_SELECTOR);
    }

    public ServiceRegistrationRoutePolicyFactory(ServiceRegistry.Selector serviceRegistrySelector) {
        this(null, serviceRegistrySelector);
    }

    public ServiceRegistrationRoutePolicyFactory(ServiceRegistry serviceRegistry, ServiceRegistry.Selector serviceRegistrySelector) {
        this.serviceRegistry = serviceRegistry;
        this.serviceRegistrySelector = serviceRegistrySelector;
    }

    @Override
    public RoutePolicy createRoutePolicy(CamelContext camelContext, String routeId, RouteDefinition route) {
        return new ServiceRegistrationRoutePolicy(this.serviceRegistry, this.serviceRegistrySelector);
    }
}

