/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.rest.endpoints;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.opencsv.CSVWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.jws.WebService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharing;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.services.ConfigSharingService;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.rest.service.RestServiceUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@WebService
@CrossOriginResourceSharing(allowAllOrigins=true, allowCredentials=true)
@Path(value="/")
@Component(service={ClientEndpoint.class}, property={"osgi.jaxrs.resource=true"})
public class ClientEndpoint {
    private static final String CONTENT_DISPOSITION_HEADER_KEY = "Content-Disposition";
    private static final String FILE_NAME_WO_EXT = "my-profile";
    @Reference
    private ProfileService profileService;
    @Reference
    private ConfigSharingService configSharingService;
    @Reference
    private RestServiceUtils restServiceUtils;
    @Context
    HttpServletRequest request;
    @Context
    HttpServletResponse response;

    private static String getContentDispostionHeader(String extension) {
        return String.format("attachment; filename=\"%s.%s\"", FILE_NAME_WO_EXT, extension);
    }

    @OPTIONS
    @Path(value="/client/{operation}/{param}")
    public Response options() {
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @GET
    @Path(value="/client/{operation}/{param}")
    public Response getClient(@PathParam(value="operation") String operation, @PathParam(value="param") String param) throws JsonProcessingException {
        if ("myprofile".equals(operation)) {
            if (((String)this.configSharingService.getProperty("allowedProfileDownloadFormats")).contains(param)) {
                return this.donwloadCurrentProfile(param);
            }
            throw new InternalServerErrorException(String.format("%s is not an allowed param", param));
        }
        throw new NotFoundException();
    }

    private Response donwloadCurrentProfile(String downloadFileType) throws JsonProcessingException {
        Profile currentProfile;
        String cookieProfileId = this.restServiceUtils.getProfileIdCookieValue(this.request);
        if (cookieProfileId != null && (currentProfile = this.profileService.load(cookieProfileId)) != null) {
            switch (downloadFileType) {
                case "yaml": {
                    return this.prepareYamlFileToDownload(currentProfile, false);
                }
                case "json": {
                    return this.prepareJsonFileToDownload(currentProfile);
                }
                case "csv": {
                    return this.prepareCsvFileToDownload(currentProfile, this.request.getParameter("vertical") != null);
                }
                case "text": {
                    return this.prepareYamlFileToDownload(currentProfile, true);
                }
            }
            throw new NotFoundException();
        }
        throw new NotFoundException();
    }

    private Response prepareCsvFileToDownload(Profile currentProfile, boolean vertical) {
        this.response.setContentType("text/csv");
        this.response.setHeader(CONTENT_DISPOSITION_HEADER_KEY, ClientEndpoint.getContentDispostionHeader("csv"));
        StringWriter writer = new StringWriter();
        CSVWriter csvWriter = new CSVWriter((Writer)writer);
        if (vertical) {
            csvWriter.writeNext(new String[]{"name", "value"});
            for (Map.Entry entry : currentProfile.getProperties().entrySet()) {
                csvWriter.writeNext(new String[]{(String)entry.getKey(), entry.getValue().toString().trim().replace("\n", "")});
            }
        } else {
            Set keySet = currentProfile.getProperties().keySet();
            ArrayList<String> values = new ArrayList<String>();
            for (Object value : currentProfile.getProperties().values()) {
                values.add(value.toString().trim().replace("\n", ""));
            }
            csvWriter.writeNext(keySet.toArray(new String[0]));
            csvWriter.writeNext(values.toArray(new String[0]));
        }
        Response.ResponseBuilder responseBuilder = Response.ok((Object)writer.toString());
        return responseBuilder.build();
    }

    private Response prepareJsonFileToDownload(Profile currentProfile) throws JsonProcessingException {
        this.response.setContentType("text/json");
        this.response.setHeader(CONTENT_DISPOSITION_HEADER_KEY, ClientEndpoint.getContentDispostionHeader("json"));
        ObjectMapper mapper = new ObjectMapper();
        String jsonContent = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)currentProfile.getProperties());
        return Response.ok((Object)jsonContent).build();
    }

    private Response prepareYamlFileToDownload(Profile currentProfile, boolean asTextFile) throws JsonProcessingException {
        this.response.setContentType("text/" + (asTextFile ? "plain" : "yaml"));
        this.response.setHeader(CONTENT_DISPOSITION_HEADER_KEY, ClientEndpoint.getContentDispostionHeader(asTextFile ? "txt" : "yml"));
        YAMLFactory yf = new YAMLFactory();
        ObjectMapper mapper = new ObjectMapper((JsonFactory)yf);
        String yamlContent = mapper.writeValueAsString((Object)currentProfile.getProperties());
        return Response.ok((Object)yamlContent).build();
    }
}

