/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.resource;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.wicket.util.file.File;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipResourceStream
extends AbstractResourceStream {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ZipResourceStream.class);
    private final transient ByteArrayOutputStream bytearray;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipResourceStream(File dir, boolean recursive) {
        Args.notNull(dir, "dir");
        Args.isTrue(dir.isDirectory(), "Not a directory: '{}'", dir);
        this.bytearray = new ByteArrayOutputStream();
        try (ZipOutputStream out = new ZipOutputStream(this.bytearray);){
            ZipResourceStream.zipDir(dir, out, "", recursive);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ZipResourceStream(File dir) {
        this(dir, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipDir(File dir, ZipOutputStream out, String path, boolean recursive) throws IOException {
        Args.notNull(dir, "dir");
        Args.isTrue(dir.isDirectory(), "Not a directory: '{}'", dir);
        String[] files = dir.list();
        int BUFFER = 2048;
        byte[] data = new byte[BUFFER];
        if (files != null) {
            for (String file : files) {
                log.debug("Adding: '{}'", (Object)file);
                File f = new File(dir, file);
                if (f.isDirectory()) {
                    if (!recursive) continue;
                    ZipResourceStream.zipDir(f, out, path + f.getName() + "/", recursive);
                    continue;
                }
                out.putNextEntry(new ZipEntry(path + f.getName()));
                FileInputStream fi = new FileInputStream(f);
                try (BufferedInputStream origin = new BufferedInputStream(fi, BUFFER);){
                    int count;
                    while ((count = origin.read(data, 0, BUFFER)) != -1) {
                        out.write(data, 0, count);
                    }
                }
            }
        }
        if (path.isEmpty()) {
            out.close();
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public String getContentType() {
        return null;
    }

    @Override
    public InputStream getInputStream() throws ResourceStreamNotFoundException {
        return new ByteArrayInputStream(this.bytearray.toByteArray());
    }

    @Override
    public Bytes length() {
        return Bytes.bytes(this.bytearray.size());
    }

    @Override
    public Time lastModifiedTime() {
        return null;
    }
}

