/*
 * ChownHandler.java
 *
 * Brazil project web application toolkit,
 * export version: 2.1 
 * Copyright (c) 2000-2004 Sun Microsystems, Inc.
 *
 * Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License Version 
 * 1.0 (the "License"). You may not use this file except in compliance with 
 * the License. A copy of the License is included as the file "license.terms",
 * and also available at http://www.sun.com/
 * 
 * The Original Code is from:
 *    Brazil project web application toolkit release 2.1.
 * The Initial Developer of the Original Code is: suhler.
 * Portions created by suhler are Copyright (C) Sun Microsystems, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s): suhler.
 *
 * Version:  2.2
 * Created by suhler on 00/10/02
 * Last modified by suhler on 04/11/30 15:19:42
 */

package sunlabs.brazil.handler;

import sunlabs.brazil.server.Handler;
import sunlabs.brazil.server.Request;
import sunlabs.brazil.server.Server;
import java.io.IOException;
import com.sun.server.ServerProcess;

/**
 * Handler for changing the group and owner of the server.
 * This handler  expects the "server.so" file used by the
 * <a href=http://www.sun.com/software/jwebserver>
 * Java Webserver 2.0</a>
 * Make sure you rename the file lib<code>server.so</code>
 * in the distribution to lib<code>com_sun_server_ServerProcess.so</code>, and
 * put it where it will be found by <b>System.loadLibrary</b>.
 * <br>
 * Note:  If the native library is unalvailable on your platform, 
 * try the <i>RunAs</i> handler, that includes the native source code.
 * <p>
 * Properties:
 * <dl class=props>
 * <dt>userName	<dd>name of the user to run as
 * <dt>groupName  <dd>The name of the group to run as
 * </dl>
 *
 * @author      Stephen Uhler
 * @version		2.2
 */

public class ChownHandler implements Handler {

    /**
     * set up the Unix user and group.
     * We could return false, so our respond method would never be called, 
     * but some containers cause the server to exit on false returns.
     */

    public boolean
    init(Server server, String prefix) {
	String user = server.props.getProperty(prefix + "userName");
	String group = server.props.getProperty(prefix + "groupName");
	try {
	    if (user != null && ServerProcess.setUser(user)) {
		System.out.println("Setting server to run as user: " + user);
	    }
	    if (group != null && ServerProcess.setGroup(group)) {
		System.out.println("Setting server to run as group: " + group);
	    }
	} catch (UnsatisfiedLinkError e) {
	    System.out.println(prefix + " not available: " + e.getMessage());
	    return false;
	}
	return true;
    }

    /**
     * Nothing to respond to
     */

    public boolean
    respond(Request request) throws IOException {
	return false;
    }
}
