/*
 * NoImageTemplate.java
 *
 * Brazil project web application toolkit,
 * export version: 2.1 
 * Copyright (c) 1999-2003 Sun Microsystems, Inc.
 *
 * Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License Version 
 * 1.0 (the "License"). You may not use this file except in compliance with 
 * the License. A copy of the License is included as the file "license.terms",
 * and also available at http://www.sun.com/
 * 
 * The Original Code is from:
 *    Brazil project web application toolkit release 2.1.
 * The Initial Developer of the Original Code is: suhler.
 * Portions created by suhler are Copyright (C) Sun Microsystems, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s): cstevens, suhler.
 *
 * Version:  2.2
 * Created by suhler on 99/06/18
 * Last modified by suhler on 03/07/15 09:11:24
 */

package sunlabs.brazil.template;

/**
 * Sample template class for removing all images
 * from a web page, and replacing them with their alt strings.
 * This class is used by the TemplateHandler
 * Each image is replaced by a text string defined by the server property
 * "template", which the first "%" replaced by the contents of the
 * alt attribute.  Defaults to "[&lt;b&gt;%&lt;b&gt;]".
 * <dl class=props>
 * <dt><code>template</code>
 * <dd>The text used to replace the image. The first "%" will contain the image
 * "alt" string, if any.
 * </dl>
 *
 * @author		Stephen Uhler
 * @version		NoImageTemplate.java
 */

public class NoImageTemplate
    extends Template
{
    private String template = "[<b>%</b>]";
    private boolean filterOther; // only filter non-local images
    private String mine;
    private int index;

    /**
     * Save a reference to our request properties
     * We'll use it some day to tailor the image display
     */

    public boolean
    init(RewriteContext hr)
    {
	template  = hr.request.props.getProperty(hr.prefix + "template",
		template);
	filterOther  = (null != hr.request.props.getProperty(hr.prefix + "nonlocal", null));
	mine = hr.request.serverUrl();
	index = template.indexOf("%");
	// System.out.println("mine=" + mine + "  filter = " + filterOther);

	return true;
    }

    /**
     * Convert the html tag img into text using the alt string
     * @param h	The name/value pairs
     *  src=
     *  alt=<...>
     */

    public void
    tag_img(RewriteContext hr)
    {

	// Only nuke non-local images - XXX for testing

	if (filterOther) {
	    String src = hr.get("src",null);
	    if (src.indexOf("http://") < 0 || src.indexOf(mine) >= 0) {
		return;
	    }
	    // System.out.println( "Stripping image: " + src);
	}

	String alt = hr.get("alt",null);
	if (alt == null) {
	    alt = "image";
	}
	if (index >= 0) {
	    hr.append(template.substring(0,index) +
		    alt + template.substring(index+1));
	} else {
	    hr.append(template);
	}
    }
}
